<?php 
session_start();

if(!$_SESSION['u_logeado']) {
	header("location:../login.php");
	exit();
}
include_once "header.php";
?>
<div style="margin: 0 2% 0 2%" id="app">
	<!-- Main container -->
	<nav class="level mt-5">
	  <!-- Left side -->
	  <div class="level-left">
	    <div class="level-item">
	      <p class="title is-2"><strong>{{ usuarios.length }}</strong> Usuarios</p>
	    </div>


	  </div>

	  <!-- Right side -->
	  <div class="level-right">
	   
	    <p class="level-item">
	    	<a class="button is-success" @click=" verModal = true ">
	    		<i class="fa fa-plus"></i>&nbsp	
	    		Nuevo
	    	</a>
	    </p>
	  </div>
	</nav>
	<div class="box">
		<table class="table is-bordered is-striped is-narrow is-hoverable is-fullwidth">
			<thead>
				<th>Nombre</th>	
				<th>Usuario</th>	
				<th>Opciones</th>	
			</thead>
			<tbody>
				<tr v-for="u in usuarios" :key="u.id_usuario">
					<td>{{ u.nombre_completo }}</td>
					<td>{{ u.nombre_usuario}}</td>
					<td>
						<button class="button is-info is-outlined is-small" @click="editar(u)">
							<i class="fa fa-edit"></i>
						</button>
						<button class="button is-danger is-outlined is-small" @click="eliminar(u)">
							<i class="fa fa-trash"></i>
						</button>
					</td>
				</tr>
			</tbody>
		</table>
	</div>

	<div class="modal" :class="{'is-active': verModal}">
	  <div class="modal-background"></div>
	  <div class="modal-card">
	    <header class="modal-card-head">
	      <p class="modal-card-title">{{ accionModal }} Usuario</p>
	      <button class="delete" aria-label="close" @click="cerrarModal"></button>
	    </header>
	    <section class="modal-card-body">
	    	<div class="field">
			  <label class="label">Nombre Completo *</label>
			  <div class="control has-icons-left has-icons-right">
			    <input class="input" type="text" placeholder="Nombre completo" v-model="usuario.nombre">
			    <span class="icon is-small is-left">
			      <i class="fas fa-user"></i>
			    </span>
			  </div>
			</div>

			<div class="field">
			  <label class="label">Nombre Usuario *</label>
			  <div class="control has-icons-left has-icons-right">
			    <input class="input" type="text" placeholder="Nombre usuario" v-model="usuario.nombreUsuario">
			    <span class="icon is-small is-left">
			      <i class="fas fa-user-secret"></i>
			    </span>
			  </div>
			</div>

			<div class="field" v-if=" accionModal === 'Agregar'">
			  <label class="label">Contraseña *</label>
			  <div class="control has-icons-left has-icons-right">
			    <input class="input" type="text" placeholder="Contraseña" v-model="usuario.password">
			    <span class="icon is-small is-left">
			      <i class="fas fa-key"></i>
			    </span>
			  </div>
			</div>
	    </section>
	    <footer class="modal-card-foot">
	      <div class="buttons">
	        <button class="button is-success" @click="registrar">Guardar</button>
	        <button class="button" @click="cerrarModal">Cancelar</button>
	      </div>
	    </footer>
	  </div>
	</div>
</div>
<?php include_once "footer.php"?>
<script>
	new Vue({
	el: "#app",
	data:()=> ({
		verModal: false,
		accionModal: 'Agregar',
		usuario: {
			nombre: "",
			nombreUsuario: "",
			password: ""
		},
		usuarios: []
	}),

	mounted(){
		this.obtener()
	},

	methods: {
		editar(usuario){
			this.accionModal = 'Editar'
			this.usuario = {
				id: usuario.id_usuario,
				nombre: usuario.nombre_completo,
				nombreUsuario: usuario.nombre_usuario,
			}

			this.verModal = true
		},

		eliminar(usuario){
			Swal.fire({
			  title: `¿Seguro que deseas eliminar el usuario ${usuario.nombre_completo}?`,
			  text: "¡Esta acción no se puede deshacer!",
			  icon: "warning",
			  showCancelButton: true,
			  confirmButtonColor: "#3085d6",
			  cancelButtonColor: "#d33",
			  confirmButtonText: "Sí, eliminar",
			  cancelButtonText: "Cancelar"
			}).then(async (result) => {
			  if (result.isConfirmed) {
			    try{
			    	let respuesta = await fetch("../controller/Usuarios.php",{
						method: "POST",
						headers: {
	                        "Content-Type": "application/json"
	                    },
						body: JSON.stringify({ accion: 'eliminar', id: usuario.id_usuario})
					})

					let resultado = await respuesta.json()
					if(resultado){
						Swal.fire({
						  position: "top-end",
						  icon: "success",
						  title: "Usuario eliminado",
						  showConfirmButton: false,
						  timer: 1500
						})
						this.obtener()
					}

			    } catch(error){
			    	alert("Error al eliminar el usuario  " + error)
			    }
			  }
			})
		},

		async obtener(){
			try {
				let payload = {
					accion: 'obtener',
				}

				let respuesta = await fetch("../controller/Usuarios.php",{
					method: "POST",
					headers: {
                        "Content-Type": "application/json"
                    },
					body: JSON.stringify(payload)
				})

				let resultado = await respuesta.json()
				if(resultado){
					this.usuarios = resultado
				}
			} catch(error){
				alert("Error al obtener los datos " + error)
			}
		},

		async registrar(){
			if(this.usuario.nombre === "" || this.usuario.nombreUsuario === "" ) {
				alert("Coloca los campos marcados con *")
				return;
			}

			if(this.accionModal === "Agregar" && this.usuario.password === ""){
				alert("Coloca los campos marcados con *")
				return;
			}

			if(this.accionModal === "Agregar" && this.usuario.password.length <8 ){
				alert("La contraseña debe contener al menos 8 caracteres")
				return;
			}
			try {
				let payload = {
					usuario: this.usuario,
					accion: this.accionModal === 'Agregar' ? 'nuevo' : 'editar'
				}

				let respuesta = await fetch("../controller/Usuarios.php",{
					method: "POST",
					headers: {
                        "Content-Type": "application/json"
                    },
					body: JSON.stringify(payload)
				})

				let resultado = await respuesta.json()
				if(resultado){
					let mensaje = this.accion === 'Agregar' ? 'Usuario registrado': 'Cambios guardados'
					Swal.fire({
					  position: "top-end",
					  icon: "success",
					  title: mensaje,
					  showConfirmButton: false,
					  timer: 1500
					})
					this.cerrarModal()
					this.obtener()
				}
			} catch(error){
				alert("Error al registrar los datos " + error)
			}
		},

		cerrarModal(){
			this.verModal = false
			this.usuario = {
				nombre: "",
				nombreUsuario: "",
				password: ""
			}
			this.accionModal = 'Agregar'
		}
	}
})
</script>